﻿# Install the MSOnline module if not already installed
if (-not (Get-Module -ListAvailable -Name MSOnline)) {
    Write-Host "Installing MSOnline module..." -ForegroundColor Yellow
    Install-Module -Name MSOnline -Force
}

# Connect to MSOnline
Write-Host "Connecting to MSOnline. Please log in with your Azure admin credentials." -ForegroundColor Cyan
Connect-MsolService

# Prompt the user to enter the UPN of the Azure user
$userPrincipalName = Read-Host "Enter the UserPrincipalName (UPN) of the Azure user (e.g., user@example.com)"

# Check if the user has an ImmutableID
Write-Host "Fetching user details..." -ForegroundColor Cyan
$userDetails = Get-MsolUser -UserPrincipalName $userPrincipalName
if ($userDetails) {
    Write-Host "User details:" -ForegroundColor Green
    $userDetails | fl
    if ($userDetails.ImmutableId) {
        Write-Host "The user has an ImmutableID: $($userDetails.ImmutableId)" -ForegroundColor Yellow
        $clearImmutableId = Read-Host "Do you want to clear the ImmutableID? (Yes/No)"
        if ($clearImmutableId -eq ("Yes")) {
            Write-Host "Clearing ImmutableID..." -ForegroundColor Cyan
            Set-MsolUser -UserPrincipalName $userPrincipalName -ImmutableId $null
            Write-Host "ImmutableID cleared successfully." -ForegroundColor Green
        } else {
            Write-Host "Operation canceled. ImmutableID was not cleared." -ForegroundColor Red
        }
    } else {
        Write-Host "The user does not have an ImmutableID." -ForegroundColor Green
    }
} else {
    Write-Host "User not found. Please check the UPN and try again." -ForegroundColor Red
    exit
}

# Prompt to proceed with creating an On-Prem user
$createOnPremUser = Read-Host "Do you want to create an On-Prem user with the same UPN? (Yes/No)"
if ($createOnPremUser -eq "Yes") {
    Write-Host "Ensure the On-Prem user has the same UPN as the Azure user." -ForegroundColor Cyan
    Write-Host "Once created, synchronize using the Active Directory Synchronization Tool." -ForegroundColor Green
    # Prompt to proceed is a user is using the script on a Domain Controller with Active Directory Synchronization Tool installed
    $OnDC = Read-Host "Are you logged into the Domain controller with ADSync tool installed? (Yes/No)"
    if ($OnDC -eq "Yes") {
        $startSync = Read-Host "Do you want to start the synchronization process now? (Yes/No)"
        if ($startSync -eq "Yes") {
            Write-Host "Starting Active Directory Synchronization..." -ForegroundColor Cyan
            try {
                # Attempt to start the sync cycle
                Start-ADSyncSyncCycle -PolicyType Delta
                Write-Host "Synchronization completed successfully." -ForegroundColor Green
            } catch {
                # Handle errors and notify the user
                Write-Host "Synchronization Failed. Check ADSync Service." -ForegroundColor Red
            }
        } else {
        Write-Host "Operation canceled. Synchronization was not started." -ForegroundColor Red
        }
    } else {
        Write-Host " "
        Write-Host " "
        Write-Host "Start the Active Directory Synchronization manually using the following command."
        Write-Host "Start-ADSyncSyncCycle -PolicyType Delta"
    }
} else {
    Write-Host " "
    Write-Host " "
    Write-Host "Operation canceled. No On-Prem user was created. Continue manually on the Domain Controller." -ForegroundColor Red
}

Write-Host "Script execution completed." -ForegroundColor Green